clear all
capture log close
program drop _all
set more off
snapshot erase _all

********************************************************************************************
********************************************************************************************
********************************************************************************************
*** How much do we really know about inequality within countries around the world? Adjusting Gini coefficients for missing top incomes
*** Laurence Chandy & Brina Seidel
***
*** Last Updated: 2/10/2017
***
*** This master do file calls all subsequent do files that are needed to clean and analyze the data. 
********************************************************************************************
********************************************************************************************
********************************************************************************************

**************************************
*** Set your working directory here
**************************************
global directory = "xxxxxxxxxxxxxxxxxxx"
cd "$directory"

**************************************
*** Change the PLUS directory, which stores the graph scheme used in the programs that follow
*** Note: You will want to change this back to your personal directory after running this code
**************************************
sysdir set PLUS "$directory/Directory Files"

**************************************
*** Set graph styles
**************************************
set scheme graphscheme
graph set window fontface "Calibri"

**************************************
*** Prepare P's and L's.do
***
*** This file reads in the raw p's and l's data from PovcalNet and LIS, then
***		1. Estimates the parameters of the GQ and Beta models of the Lorenz curve for surveys for which we have <100 p's and l's
***		2. Determines the best model to use for each survey based on 1) validity and 2) goodness of fit
***		3. Uses the best model (GQ or Beta) to calculate 100 fitted p's and l's for surveys where we have <100 p's and l's
***		4. Combines the urban and rural income distributions into a national income distribution for countries with urban and rural p's and l's
*** 		5. Saves the prepared p's and l's data
*** Output data: Output Data/Cleaned P's and L's.dta
**************************************
do "Programs/Prepare P's and L's.do"

**************************************
*** Calculate Pareto-Adjusted P's and L's.do
***
*** This file reads in the cleaned p's and l's data, then
***		1. Calculates the pareto parameter alpha that will characterize the top of the adjusted income distribution
***		2. Calculates new pareto-adjusted p's and l's based on the calculated value of alpha
***		3. Saves the data
*** Output data: Output Data/Raw and Pareto-Adjusted P's and L's.dta
**************************************
do "Programs/Calculate Pareto-Adjusted P's and L's.do"

**************************************
*** Calculate Raw and Pareto-Adjusted Ginis.do
***
*** This file reads in the raw and pareto-adjusted p's and l's data, then
***		1. Calculates the raw and pareto-adjusted gini values
***		2. Saves the results
***	Output data: Output Data/Raw and Pareto-Adjusted Ginis.dta
**************************************
do "Programs/Calculate Raw and Pareto-Adjusted Ginis.do"

**************************************
*** Produce Statistics and Figures for Blog Post.do
***
*** This file reads in the raw and pareto-adjusted ginis, then
***		1. Calculate miscellanous statistics for blog post
***		2. Produces figures for blog post
***		3. Produces figures for technical appendix 
**************************************
do "Programs/Produce Statistics and Figures for Blog Post.do"

